/*=========================================================*/
/*
 *  Listing 4.  devinit.h - include file for generic device
 *
 *  Placed in the Public Domain by Forest W. Arnold, 1994
*/
/*=========================================================*/

#ifndef     DEVINIT_H
#define     DEVINIT_H

#include <exec/types.h>
#include <exec/execbase.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <exec/libraries.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/errors.h>
#include <dos/dos.h>
#include <clib/exec_protos.h>
#include <clib/dos_protos.h>

/*
 *  device commands - the generic device implements
 *  debug commands to turn on/off trace output to
 *  a shell window
 *
 *  The file handle for the output console must be
 *  passed to the device in the io_Data field of
 *  the IOStdReq when the DBG commands are sent.
 *  
 *  To turn debug off, the file handle must be the
 *  same as the file handle that was used to turn
 *  debug on.
*/

#define  DEV_DBG_ON        (CMD_NONSTD+0)
#define  DEV_DBG_OFF       (CMD_NONSTD+1)
#define  DEV_LASTCMD       DEV_DBG_OFF
#define  USRDEV_LASTCMD    (DEV_LASTCMD)

/*
 *  error codes for debug commands
*/

#define DEVERR_DBGBUSY  (-8)  /* debug already on     */
#define DEVERR_BADFH    (-9)  /* dbg file handle
                                 mismatch             */

/*
 *  the device-specific data - appended to library node
 *  The code in devinit.c manages the segList, execBase,
 *  flags, and dbgFH members.  Specific devices define
 *  structures for their specific data elements and
 *  set the 'data' member of the device structure to
 *  the address of their structure.
*/

typedef struct SignalSemaphore Semaphore_t,*Semaphore_p;

struct DevData {
   BPTR  segList; 
   APTR  execBase;
   ULONG flags;
   BPTR  dbgFH;
   Semaphore_t *lock;
   APTR  data;
};

/*
 *  Generic device structure.
 *
 *  This structure is also defined in the assembly
 *  language module for the device.
*/

struct GenericDevice {
   struct Library dev_Lib;
   USHORT         dev_Pad;
   struct DevData dev_Data;
};

/*
 *  Pointers to exec and dos base addresses
*/

extern struct ExecBase *SysBase;
extern struct DosLibrary *DOSBase;


#endif	/* DEVINIT_H */
